function components = getConnectedComponents(obj,varargin)
%GETCONNECTEDCOMPONENTS Find connected components of AdjacencyMatrix object
%obj
%   COMPONENTS = GETCONNECTEDCOMPONENTS(OBJ, ... param, paramValue ...)
%   will return a cell array of adjacency matrix objects, each of which is
%   distinct connected component of obj
%
%   Parameters:
%       'tolerance' - The function will ignore edge weights less than the
%       given tolerance.  This is to ignore possible noise present in the
%       data
%       'weak' - Must be true or false.  Default is true.  Determines
%           whether it will consider the weak or strong definition of
%           connected components in directed network - if true, this
%           function will treat edges as bidirectional in finding
%           components (ie vertices in the components may not be mutually
%           accessible)
%
%   This depends on the bioinformatics toolbox function 'graphconncomp'

% Set default value for parameters
tolerance = 1;
weak = true;
randCalc = false;
for i = 1:2:numel(varargin)
    switch varargin{i}
        case 'tolerance'
            tolerance = varargin{i+1};
        case 'weak'
            weak = varargin{i+1};
        case 'randCalc'
            randCalc = varargin{i+1};
    end                   
end

[A labels] = getSquareMatrix(obj);
A2 = A;
A2(A2<tolerance) = 0;
[S C] = graphconncomp(A2,'weak',weak);

components = {};
iter = 1;
for i = 1:S
    if sum(C==i) == 1
        fprintf('%s is singleton component\n',labels{C==i});
    else
        components{iter} = AdjacencyMatrix(A(C==i,C==i),labels(C==i),labels(C==i)',obj.matrixType);
        iter = iter + 1;
    end
    
end

nIters = 200;
nComps = zeros(1,nIters);
if randCalc
    Crand = zeros(nIters,1);
    for i = 1:nIters
        Arand = randmio_dir(A2,20);  %rewire A
        Arand(logical(eye(size(Arand)))) = 0;
        [nComps(i) C] = graphconncomp(Arand,'weak',weak);
        
    end
    
    hist(nComps);
    fprintf('Mean number of components for randomly rewired graphs: %.4f\n',mean(nComps));
end



end

